<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTechnicianRatingsTable extends Migration {

	public function up()
	{
		Schema::create('technician_ratings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('technician_id');
			$table->integer('user_id');
			$table->integer('rating');
			$table->string('subject', 255);
			$table->text('feedback')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('technician_ratings');
	}
}