<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->text('name')->nullable();
			$table->text('address')->nullable();
			$table->datetime('date_of_birth')->nullable();
			$table->text('phone')->nullable();
			$table->text('email');
			$table->text('email_verified_at')->nullable();
			$table->string('password');
			$table->text('photo');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}