<?php

namespace Request;

use Illuminate\Database\Eloquent\Model;

class Request extends Model 
{

    protected $table = 'Request';
    public $timestamps = false;

    public function toDocuments()
    {
        return $this->hasMany('Files');
    }

    public function toNotifications()
    {
        return $this->hasMany('Notifications');
    }

    public function toMessages()
    {
        return $this->hasMany('Sms');
    }

    public function toHistory()
    {
        return $this->hasMany('AuditLogs');
    }

    public function requestToEmail()
    {
        return $this->hasMany('Email');
    }

    public function toDept()
    {
        return $this->hasOne('Departement');
    }

}