<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('perfil', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscribe', function(Blueprint $table) {
			$table->foreign('perfil_id')->references('id')->on('perfil')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscribe', function(Blueprint $table) {
			$table->foreign('plans_id')->references('id')->on('plans')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('propertyimage', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('property')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('propertylink', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('property')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('propertylink', function(Blueprint $table) {
			$table->foreign('perfil_id')->references('id')->on('perfil')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('perfilconfig', function(Blueprint $table) {
			$table->foreign('perfil_id')->references('id')->on('perfil')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('propertylocation', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('property')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permit_perfil', function(Blueprint $table) {
			$table->foreign('permits_id')->references('id')->on('permits')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permit_perfil', function(Blueprint $table) {
			$table->foreign('perfil_id')->references('id')->on('perfil')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('perfil', function(Blueprint $table) {
			$table->dropForeign('perfil_user_id_foreign');
		});
		Schema::table('subscribe', function(Blueprint $table) {
			$table->dropForeign('subscribe_perfil_id_foreign');
		});
		Schema::table('subscribe', function(Blueprint $table) {
			$table->dropForeign('subscribe_plans_id_foreign');
		});
		Schema::table('propertyimage', function(Blueprint $table) {
			$table->dropForeign('propertyimage_property_id_foreign');
		});
		Schema::table('propertylink', function(Blueprint $table) {
			$table->dropForeign('propertylink_property_id_foreign');
		});
		Schema::table('propertylink', function(Blueprint $table) {
			$table->dropForeign('propertylink_perfil_id_foreign');
		});
		Schema::table('perfilconfig', function(Blueprint $table) {
			$table->dropForeign('perfilconfig_perfil_id_foreign');
		});
		Schema::table('propertylocation', function(Blueprint $table) {
			$table->dropForeign('propertylocation_property_id_foreign');
		});
		Schema::table('permit_perfil', function(Blueprint $table) {
			$table->dropForeign('permit_perfil_permits_id_foreign');
		});
		Schema::table('permit_perfil', function(Blueprint $table) {
			$table->dropForeign('permit_perfil_perfil_id_foreign');
		});
	}
}