<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id', 'inviteid', 'groupid', 'email');
	protected $visible = array('id', 'inviteid', 'groupid', 'email');

	public function getInvite()
	{
		return $this->hasOne('Invite', 'id', 'inviteid');
	}

	public function getGroup()
	{
		return $this->belongsTo('Group', 'id', 'groupid');
	}

	public function getVerification()
	{
		return $this->hasOne('Activation', 'email', 'email');
	}

}