<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('username');
			$table->string('email')->unique();
			$table->string('first_name');
			$table->string('last_name');
			$table->enum('sex', array('male', 'female'));
			$table->date('date_of_birth');
			$table->string('phone_number')->nullable();
			$table->string('street');
			$table->string('area');
			$table->string('city');
			$table->string('password');
			$table->string('profile_picture')->nullable();
			$table->integer('country_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->integer('local_government_id')->unsigned();
			$table->integer('role_id')->unsigned();
			$table->boolean('terms_and_conditions');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}