<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessTable extends Migration {

	public function up()
	{
		Schema::create('business', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('logo');
			$table->string('type');
			$table->string('description');
			$table->string('phone_number');
			$table->string('email');
			$table->string('year_started');
			$table->string('area');
			$table->string('street');
			$table->string('city');
			$table->integer('country_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->integer('local_government_id')->unsigned();
			$table->integer('vendor_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('business');
	}
}