<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('body', 191);
			$table->bigInteger('chapter_id')->unsigned()->index();
			$table->bigInteger('lesson_id')->unsigned()->index();
			$table->tinyInteger('level')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}