<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Parametre extends Model 
{

    protected $table = 'parametres';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_plan', 'slug', 'pourcentageInteret', 'moisMin', 'moisMax', 'etat');
    protected $visible = array('id_plan', 'slug', 'pourcentageInteret', 'moisMin', 'moisMax', 'etat');

    public function plan()
    {
        return $this->belongsTo('App\Plan', 'id_plan');
    }

}