<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Plan extends Model 
{

    protected $table = 'plans';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'libelle', 'etat');
    protected $visible = array('slug', 'libelle', 'etat');

    public function parametre()
    {
        return $this->hasMany('App\Parametre', 'id_plan');
    }

    public function depot()
    {
        return $this->hasMany('App\Depot', 'id_plan');
    }

    public function client()
    {
        return $this->hasMany('App\Client', 'id_plan');
    }

    public function clientStorry()
    {
        return $this->hasMany('App\ClientSorry', 'id_plan');
    }

}