<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Agence extends Eloquent {

	protected $table = 'agences';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'nom', 'quartier', 'telephone');
	protected $visible = array('nom', 'quartier', 'telephone');

	public function client()
	{
		return $this->hasMany('App\Client', 'id_agence');
	}

	public function depot()
	{
		return $this->hasMany('App\Depot', 'id_agence');
	}

	public function clientStorry()
	{
		return $this->hasMany('App\ClientSorry', 'id_agence');
	}

	public function retrait()
	{
		return $this->hasMany('App\Retrait', 'id_agence');
	}

}