<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_createur', 'id_agence', 'id_plan', 'dureeProjet', 'nom', 'prenom', 'sexe', 'date_naissance', 'photoVersoCNI', 'photoPasseport', 'photoRectoCNI', 'etat', 'statutConfirmation', 'solde', 'photo');
	protected $visible = array('slug', 'id_createur', 'id_agence', 'id_plan', 'dureeProjet', 'nom', 'prenom', 'sexe', 'date_naissance', 'photoVersoCNI', 'photoPasseport', 'photoRectoCNI', 'etat', 'statutConfirmation', 'solde', 'photo');

	public function compte()
	{
		return $this->hasMany('App\Compte', 'id_client');
	}

	public function depot()
	{
		return $this->hasMany('App\Depot', 'id_client');
	}

	public function retrait()
	{
		return $this->hasMany('App\Retrait', 'id_client');
	}

	public function createur()
	{
		return $this->belongsTo('App\Utilisateur', 'id_createur');
	}

	public function interet()
	{
		return $this->hasMany('App\Interet', 'id_client');
	}

	public function plan()
	{
		return $this->belongsTo('App\Plan', 'id_plan');
	}

	public function agence()
	{
		return $this->belongsTo('App\Agence', 'id_agence');
	}

	public function clientStorry()
	{
		return $this->hasMany('App\ClientSorry', 'id_client');
	}

}