<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClientSorry extends Eloquent {

	protected $table = 'clientsorrys';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_createur', 'id_plan', 'id_agence', 'id_client', 'dureeProjet', 'nom', 'prenom', 'sexe', 'date_naissance', 'photoVersoCNI', 'photoPasseport', 'photoRectoCNI', 'etat', 'solde', 'motif');
	protected $visible = array('id_createur', 'id_plan', 'id_agence', 'id_client', 'dureeProjet', 'nom', 'prenom', 'sexe', 'date_naissance', 'photoVersoCNI', 'photoPasseport', 'photoRectoCNI', 'etat', 'solde', 'motif');

	public function createur()
	{
		return $this->belongsTo('App\Utilisateur', 'id_createur');
	}

	public function plan()
	{
		return $this->belongsTo('App\Plan', 'id_plan');
	}

	public function agence()
	{
		return $this->belongsTo('App\Agence', 'id_agence');
	}

	public function client()
	{
		return $this->belongsTo('App\Client', 'id_client');
	}

}