<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Fichier extends Eloquent {

	protected $table = 'fichiers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_createur', 'slug', 'libelle');
	protected $visible = array('id_createur', 'slug', 'libelle');

	public function createur()
	{
		return $this->belongsTo('App\Utilisateur', 'id_createur');
	}

}