<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Interet extends Eloquent {

	protected $table = 'interets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_client', 'montant');
	protected $visible = array('slug', 'id_client', 'montant');

	public function client()
	{
		return $this->belongsTo('App\Client', 'id_client');
	}

}