<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Parametre extends Eloquent {

	protected $table = 'parametres';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_plan', 'slug', 'pourcentageInteret', 'moisMin', 'moisMax', 'etat');
	protected $visible = array('id_plan', 'slug', 'pourcentageInteret', 'moisMin', 'moisMax', 'etat');

	public function plan()
	{
		return $this->belongsTo('App\Plan', 'id_plan');
	}

}