<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductAttributeTable extends Migration {

	public function up()
	{
		Schema::create('product_attribute', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->index();
			$table->integer('product_id')->unsigned();
			$table->integer('attribute_id')->unsigned();
			$table->text('value_en')->nullable();
			$table->text('value_th');
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('product_attribute');
	}
}