<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->index();
			$table->string('name_en')->nullable();
			$table->string('name_th');
			$table->decimal('price', 10,3);
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
			$table->integer('category_id')->unsigned();
			$table->integer('standard_id')->unsigned();
			$table->integer('source_id')->unsigned();
			$table->integer('unit_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}