<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRewiewsTable extends Migration {

	public function up()
	{
		Schema::create('rewiews', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->index();
			$table->integer('product_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->double('rating');
			$table->text('comment')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('rewiews');
	}
}