<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStocksTable extends Migration {

	public function up()
	{
		Schema::create('stocks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->index();
			$table->integer('product_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->integer('qty')->unsigned()->default('0');
			$table->decimal('cost', 10,3);
			$table->datetime('receive_no');
			$table->string('location');
			$table->integer('warning_flag')->unsigned();
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stocks');
	}
}