<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDetailTable extends Migration {

	public function up()
	{
		Schema::create('user_detail', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->integer('title_id')->unsigned();
			$table->string('firstname')->nullable();
			$table->string('lastname');
			$table->tinyInteger('status')->default('0');
			$table->tinyInteger('gender');
			$table->date('birthdate');
			$table->integer('reward_point');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_detail');
	}
}