<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cart extends Eloquent {

	protected $table = 'cart';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $visible = array('id', 'session');

	public function cartItems()
	{
		return $this->hasMany('CartItems', 'cart_id');
	}

	public function orders()
	{
		return $this->hasMany('Order', 'cart_id');
	}

}