<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductAttribute extends Eloquent {

	protected $table = 'product_attribute';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('attribute_id', 'value_en', 'value_th');
	protected $visible = array('attribute_id', 'value_en', 'value_th');

	public function products()
	{
		return $this->belongsTo('Product', 'product_id');
	}

	public function attributes()
	{
		return $this->belongsTo('Attribute', 'attribute_id');
	}

}