<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Review extends Eloquent {

	protected $table = 'rewiews';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'user_id', 'rating', 'comment');
	protected $visible = array('product_id', 'user_id', 'rating', 'comment');

	public function products()
	{
		return $this->belongsTo('Product', 'product_id');
	}

	public function users()
	{
		return $this->belongsTo('User', 'user_id');
	}

}