<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Source extends Eloquent {

	protected $table = 'sources';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('code', 'name_en', 'name_th');
	protected $visible = array('code', 'name_en', 'name_th');

	public function products()
	{
		return $this->hasMany('Product', 'source_id');
	}

}