<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Supplier extends Eloquent {

	protected $table = 'suppliers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_th', 'created_by', 'updated_by', 'deleted_by');
	protected $visible = array('name_en', 'name_th', 'created_by', 'updated_by', 'deleted_by');

	public function stocks()
	{
		return $this->hasMany('Stock', 'supplier_id');
	}

}