<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserAddress extends Eloquent {

	protected $table = 'user_adress';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'addr', 'street', 'state', 'city', 'country', 'zipcode', 'latitude', 'longitude', 'remark', 'is_default');
	protected $visible = array('user_id', 'addr', 'street', 'state', 'city', 'country', 'zipcode', 'latitude', 'longitude', 'remark', 'is_default');

	public function users()
	{
		return $this->belongsTo('User', 'user_id');
	}

}