<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserDetail extends Eloquent {

	protected $table = 'user_detail';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'title_id', 'lastname', 'gender', 'birthdate', 'reward_point');
	protected $visible = array('user_id', 'title_id', 'lastname', 'gender', 'birthdate', 'reward_point');

	public function users()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function titles()
	{
		return $this->belongsTo('Title', 'title_id');
	}

}