<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAdressTable extends Migration {

	public function up()
	{
		Schema::create('user_adress', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('code')->index();
			$table->bigInteger('user_id')->unsigned();
			$table->text('addr')->nullable();
			$table->string('street')->nullable();
			$table->string('state')->nullable();
			$table->string('city')->nullable();
			$table->string('country')->nullable();
			$table->string('zipcode')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->text('remark')->nullable();
			$table->tinyInteger('is_default');
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_adress');
	}
}