<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBrandsTable extends Migration {

	public function up()
	{
		Schema::create('brands', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->text('description')->nullable();
			$table->string('icon', 100)->nullable();
			$table->text('categories')->nullable();
			$table->enum('status', array('pending', 'available', 'disable'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('brands');
	}
}