<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductGalaryTable extends Migration {

	public function up()
	{
		Schema::create('product_galary', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->string('image', 100);
			$table->enum('type', array('master', 'normal'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_galary');
	}
}