<?php

namespace Models/Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function brand()
    {
        return $this->belongsTo('Brand', 'brand');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}