<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingAddressTable extends Migration {

	public function up()
	{
		Schema::create('shipping_address', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('map_key')->nullable();
			$table->bigInteger('customer_id')->nullable();
			$table->string('shipping_geocode')->nullable();
			$table->string('shipping_street1')->nullable();
			$table->string('shipping_street2')->nullable();
			$table->string('shipping_city')->nullable();
			$table->string('shipping_state')->nullable();
			$table->string('shipping_country')->nullable();
			$table->string('shipping_pobox')->nullable();
			$table->string('shipping_county')->nullable();
			$table->string('shipping_postal_code')->nullable();
			$table->string('shipping_postal_code_type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_address');
	}
}