<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('doctor_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->datetime('appointment_date');
			$table->enum('status', array(''));
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}