<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('doctors', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teletherapy_sessions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teletherapy_sessions', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('test_results', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('test_results', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('doctors', function(Blueprint $table) {
			$table->dropForeign('doctors_user_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_author_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_doctor_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_patient_id_foreign');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->dropForeign('consultations_patient_id_foreign');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->dropForeign('consultations_doctor_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_patient_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_doctor_id_foreign');
		});
		Schema::table('teletherapy_sessions', function(Blueprint $table) {
			$table->dropForeign('teletherapy_sessions_patient_id_foreign');
		});
		Schema::table('teletherapy_sessions', function(Blueprint $table) {
			$table->dropForeign('teletherapy_sessions_doctor_id_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_created_by_foreign');
		});
		Schema::table('test_results', function(Blueprint $table) {
			$table->dropForeign('test_results_patient_id_foreign');
		});
		Schema::table('test_results', function(Blueprint $table) {
			$table->dropForeign('test_results_test_id_foreign');
		});
	}
}