<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractTable extends Migration {

	public function up()
	{
		Schema::create('contract', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('status');
			$table->string('reference');
			$table->bigInteger('member_id');
			$table->integer('product_id');
			$table->date('start_date');
			$table->date('end_date')->nullable();
			$table->boolean('has_custom_benefit_programs');
			$table->json('meta_data');
			$table->datetime('suspended_at');
		});
	}

	public function down()
	{
		Schema::drop('contract');
	}
}