<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLecturesTable extends Migration {

	public function up()
	{
		Schema::create('lectures', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('standard_id')->unsigned();
			$table->enum('type', array('RECORDED', 'LIVE'));
			$table->string('name');
			$table->string('video_link')->nullable();
			$table->timestamp('start_at')->nullable();
			$table->timestamp('end_at')->nullable();
			$table->boolean('is_published')->nullable();
			$table->timestamp('publish_at')->nullable();
			$table->boolean('is_active');
		});
	}

	public function down()
	{
		Schema::drop('lectures');
	}
}