<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('fields', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('standards', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lectures', function(Blueprint $table) {
			$table->foreign('standard_id')->references('id')->on('standards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lectures_pins', function(Blueprint $table) {
			$table->foreign('lecture_id')->references('id')->on('lectures')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('indicators', function(Blueprint $table) {
			$table->foreign('lecture_id')->references('id')->on('lectures')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('indicators', function(Blueprint $table) {
			$table->foreign('standard_id')->references('id')->on('standards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->foreign('lecture_id')->references('id')->on('lectures')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->foreign('standard_id')->references('id')->on('standards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('exam_id')->references('id')->on('exams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('indicator_id')->references('id')->on('indicators')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('standard_id')->references('id')->on('standards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('exam_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('exam_user', function(Blueprint $table) {
			$table->foreign('exam_id')->references('id')->on('exams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('course_teacher', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('course_teacher', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_course', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_course', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('student_course', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('answer_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('answer_user', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('answer_user', function(Blueprint $table) {
			$table->foreign('exam_user_id')->references('id')->on('exam_user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses_attachments', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses_inquiries', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses_inquiries', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses_inquires_replies', function(Blueprint $table) {
			$table->foreign('course_inquire_id')->references('id')->on('courses_inquiries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses_inquires_replies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->foreign('book_id')->references('id')->on('books')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts_contents', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('courses_progresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('courses_progresses', function(Blueprint $table) {
			$table->foreign('lecture_id')->references('id')->on('lectures')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('fields', function(Blueprint $table) {
			$table->dropForeign('fields_category_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_category_id_foreign');
		});
		Schema::table('books', function(Blueprint $table) {
			$table->dropForeign('books_course_id_foreign');
		});
		Schema::table('standards', function(Blueprint $table) {
			$table->dropForeign('standards_course_id_foreign');
		});
		Schema::table('lectures', function(Blueprint $table) {
			$table->dropForeign('lectures_standard_id_foreign');
		});
		Schema::table('lectures_pins', function(Blueprint $table) {
			$table->dropForeign('lectures_pins_lecture_id_foreign');
		});
		Schema::table('indicators', function(Blueprint $table) {
			$table->dropForeign('indicators_lecture_id_foreign');
		});
		Schema::table('indicators', function(Blueprint $table) {
			$table->dropForeign('indicators_standard_id_foreign');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->dropForeign('exams_lecture_id_foreign');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->dropForeign('exams_standard_id_foreign');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->dropForeign('exams_course_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_exam_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_indicator_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_standard_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_id_foreign');
		});
		Schema::table('exam_user', function(Blueprint $table) {
			$table->dropForeign('exam_user_user_id_foreign');
		});
		Schema::table('exam_user', function(Blueprint $table) {
			$table->dropForeign('exam_user_exam_id_foreign');
		});
		Schema::table('course_teacher', function(Blueprint $table) {
			$table->dropForeign('course_teacher_teacher_id_foreign');
		});
		Schema::table('course_teacher', function(Blueprint $table) {
			$table->dropForeign('course_teacher_course_id_foreign');
		});
		Schema::table('student_course', function(Blueprint $table) {
			$table->dropForeign('student_course_student_id_foreign');
		});
		Schema::table('student_course', function(Blueprint $table) {
			$table->dropForeign('student_course_course_id_foreign');
		});
		Schema::table('student_course', function(Blueprint $table) {
			$table->dropForeign('student_course_payment_id_foreign');
		});
		Schema::table('answer_user', function(Blueprint $table) {
			$table->dropForeign('answer_user_user_id_foreign');
		});
		Schema::table('answer_user', function(Blueprint $table) {
			$table->dropForeign('answer_user_answer_id_foreign');
		});
		Schema::table('answer_user', function(Blueprint $table) {
			$table->dropForeign('answer_user_exam_user_id_foreign');
		});
		Schema::table('courses_attachments', function(Blueprint $table) {
			$table->dropForeign('courses_attachments_course_id_foreign');
		});
		Schema::table('courses_inquiries', function(Blueprint $table) {
			$table->dropForeign('courses_inquiries_user_id_foreign');
		});
		Schema::table('courses_inquiries', function(Blueprint $table) {
			$table->dropForeign('courses_inquiries_course_id_foreign');
		});
		Schema::table('courses_inquires_replies', function(Blueprint $table) {
			$table->dropForeign('courses_inquires_replies_course_inquire_id_foreign');
		});
		Schema::table('courses_inquires_replies', function(Blueprint $table) {
			$table->dropForeign('courses_inquires_replies_user_id_foreign');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->dropForeign('print_requests_user_id_foreign');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->dropForeign('print_requests_course_id_foreign');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->dropForeign('print_requests_book_id_foreign');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->dropForeign('print_requests_payment_id_foreign');
		});
		Schema::table('print_requests', function(Blueprint $table) {
			$table->dropForeign('print_requests_coupon_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('carts_contents', function(Blueprint $table) {
			$table->dropForeign('carts_contents_coupon_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('courses_progresses', function(Blueprint $table) {
			$table->dropForeign('courses_progresses_user_id_foreign');
		});
		Schema::table('courses_progresses', function(Blueprint $table) {
			$table->dropForeign('courses_progresses_lecture_id_foreign');
		});
		Schema::table('users_addresses', function(Blueprint $table) {
			$table->dropForeign('users_addresses_user_id_foreign');
		});
	}
}