<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenusTable extends Migration {

	public function up()
	{
		Schema::create('menus', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('module_id')->unsigned();
			$table->string('menu_name', 255);
			$table->string('menu_icon', 255);
			$table->string('link', 255);
			$table->string('slug', 255);
			$table->tinyInteger('menu_order');
			$table->tinyInteger('show_hide');
			$table->integer('parent_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('menus');
	}
}