<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClassDresses extends Model 
{

    protected $table = 'dresses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function dressType()
    {
        return $this->hasOne('DressType');
    }

    public function classInfo()
    {
        return $this->hasOne('Classes');
    }

    public function addons()
    {
        return $this->hasMany('Addons');
    }

    public function measurement()
    {
        return $this->hasMany('SchoolClassMeasurement');
    }

}