<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDressTypeTable extends Migration {

	public function up()
	{
		Schema::create('dress_type', function(Blueprint $table) {
			$table->increments('dress_type_id', true);
			$table->string('type_name', 20)->nullable();
			$table->string('dress_for', 15)->nullable();
			$table->string('image', 50)->nullable();
			$table->string('price', 15)->nullable();
			$table->text('order_quantity')->nullable();
			$table->text('order_color')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('dress_type');
	}
}