<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'company';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function measurements()
	{
		return $this->hasMany('CompanyMeasurement');
	}

	public function style()
	{
		return $this->hasMany('CorporateStyleCategory');
	}

}