<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderInfo extends Eloquent {

	protected $table = 'order_info';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function orderedItem()
	{
		return $this->hasMany('OorderItem', 'fk_order_id');
	}

	public function payment()
	{
		return $this->hasOne('Payment');
	}

	public function addones()
	{
		return $this->hasOne('OrderedAddons');
	}

	public function status()
	{
		return $this->hasMany('OrderStatus');
	}

}