<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCorporateStyleCategoryTable extends Migration {

	public function up()
	{
		Schema::create('corporate_style_category', function(Blueprint $table) {
			$table->increments('style_category_id', true);
			$table->integer('fk_company')->unsigned();
			$table->string('category_name', 15)->nullable();
			$table->string('category_image')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('corporate_style_category');
	}
}