<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('culture_id')->unsigned()->index();
			$table->integer('date_format_type_id')->unsigned()->index();
			$table->string('name');
			$table->string('code', 2)->index();
			$table->string('nationality');
			$table->boolean('eu_member')->default(0);
			$table->string('number_format', 25)->nullable();
			$table->boolean('is_default')->default(0);
			$table->string('calling_code', 5)->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}