<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityLegalRepresentativesTable extends Migration {

	public function up()
	{
		Schema::create('entity_legal_representatives', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('entity_id')->unsigned()->index();
			$table->integer('natural_person_id')->unsigned();
			$table->date('from_at')->nullable();
			$table->date('to_at')->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('entity_legal_representatives');
	}
}