<?php

namespace Modules\Common\Entities\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EntityCategoryType extends Eloquent {

	protected $table = 'entity_category_type';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function entity()
	{
		return $this->belongsTo('Modules\Common\Entities\Entities\Entity');
	}

	public function categoryType()
	{
		return $this->belongsTo('Modules\Common\Entities\Entities\CategoryType');
	}

}