<?php

namespace Modules\Common\Entities\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EntityContacts extends Eloquent {

	protected $table = 'entity_contacts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contactTypes()
	{
		return $this->belongsTo('ContactType');
	}

	public function contactGroups()
	{
		return $this->belongsToMany('ContactGroup');
	}

	public function entity()
	{
		return $this->belongsTo('Entity');
	}

}