<?php

namespace Modules\Common\Entities\Entities;

class EntityNatural extends Eloquent {

	protected $table = 'entity_naturals';
	public $timestamps = true;

	public function identification()
	{
		return $this->hasMany('EntityNaturalIdentification', 'person_id', 'id');
	}

	public function gender()
	{
		return $this->belongsTo('Gender', 'gender_id', 'id');
	}

	public function marital_status()
	{
		return $this->belongsTo('MaritalStatus');
	}

	public function person()
	{
		return $this->belongsTo('Entity');
	}

}