<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityContactsTable extends Migration {

	public function up()
	{
		Schema::create('entity_contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('entity_id')->unsigned()->index();
			$table->integer('contact_type_id')->unsigned()->index();
			$table->string('name', 255)->nullable();
			$table->string('website');
			$table->string('phone')->index();
			$table->string('email')->index();
			$table->boolean('primary_contact')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('entity_contacts');
	}
}